/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.contracts.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.contracts.model.ContractSettings;
import itx.erp.contracts.service.ContractService;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.exception.InvalidStateException;
import jtbcore.model.KeyValueList;

public class ContractSettingsController
extends BaseController {
    protected ContractSettings contractSettings;
    protected ContractService contractService;

    public ContractSettings getContractSettings() {
        return this.contractSettings;
    }

    public void setContractSettings(ContractSettings contractSettings) {
        this.contractSettings = contractSettings;
    }

    public ContractService getContractService() {
        return this.contractService;
    }

    public void setContractService(ContractService contractService) {
        this.contractService = contractService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws StreamWriteException, DatabindException, IOException {
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("settings", this.contractSettings);
        req.renderJson(r);
    }

    public void saveAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        KeyValueList kvl = req.getKvl().getObject("settings");
        this.contractSettings.setDailyAlerts(kvl.getValueBool("dailyAlerts"));
        this.contractSettings.setDailyZeroUpdates(kvl.getValueBool("dailyZeroUpdates"));
        this.contractSettings.setDailyAlertsMo(kvl.getValueBool("dailyAlertsMo"));
        this.contractSettings.setDailyAlertsTu(kvl.getValueBool("dailyAlertsTu"));
        this.contractSettings.setDailyAlertsWe(kvl.getValueBool("dailyAlertsWe"));
        this.contractSettings.setDailyAlertsTh(kvl.getValueBool("dailyAlertsTh"));
        this.contractSettings.setDailyAlertsFr(kvl.getValueBool("dailyAlertsFr"));
        this.contractSettings.setDailyAlertsSa(kvl.getValueBool("dailyAlertsSa"));
        this.contractSettings.setDailyAlertsSu(kvl.getValueBool("dailyAlertsSu"));
        this.contractSettings.setWeeklySummary(kvl.getValueBool("weeklySummary"));
        this.contractSettings.setWeeklySummaryDay(kvl.getValueInt("weeklySummaryDay"));
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }

    public void userSettingsAction(WebRequest req) throws SQLException, InvalidStateException, StreamWriteException, DatabindException, IOException {
        Integer uid = req.getParamInt("userId");
        if (uid == null) {
            throw new InvalidStateException("userId not set");
        }
        HashMap<String, Boolean> settings = new HashMap<String, Boolean>();
        settings.put("dailyAlerts", this.contractService.hasDailyAlerts(uid));
        settings.put("weeklyUpdate", this.contractService.hasWeeklyUpdate(uid));
        HashMap<String, Serializable> r = new HashMap<String, Serializable>();
        r.put("success", Boolean.valueOf(true));
        r.put("settings", settings);
        req.renderJson(r);
    }

    public void saveUserSettingsAction(WebRequest req) throws SQLException, InvalidStateException, StreamWriteException, DatabindException, IOException {
        Integer uid = req.getParamInt("userId");
        if (uid == null) {
            throw new InvalidStateException("userId not set");
        }
        this.contractService.setDailyAlerts(uid, req.getParamBool("dailyAlerts"), req.getUserId());
        this.contractService.setWeeklyUpdate(uid, req.getParamBool("weeklyUpdate"), req.getUserId());
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }
}

